// =======Login==========
if (localStorage.getItem('adminLoggedIn') !== 'true') {
    window.location.href = './';
}

document.getElementById('logout-btn').addEventListener('click', function () {
    localStorage.removeItem('adminLoggedIn');
    localStorage.removeItem('adminLoginTime');
    window.location.href = './';
});

// ===== Firebase Init =====
const firebaseConfig = {
    apiKey: "AIzaSyDLPjfASCA-07itdha9wuNn43RpW-uEDMA",
    authDomain: "goodux-2025.firebaseapp.com",
    projectId: "goodux-2025",
    storageBucket: "goodux-2025.firebasestorage.app",
    messagingSenderId: "1097559910109",
    appId: "1:1097559910109:web:954d125cbb9e0b21f69d34"
};


if (!firebase.apps.length) firebase.initializeApp(firebaseConfig);
const db = firebase.firestore();

// ===== DOM Helpers =====
const qs = s => document.querySelector(s);
const qsa = s => document.querySelectorAll(s);
let records = [], selectedRecordId = null;

// ===== Notification =====
function showNotification(msg, ok=true){
    const n = qs('#notification');
    n.textContent = msg;
    n.className = `notification ${ok?'success':'error'}`;
    n.classList.remove('hidden');
    setTimeout(()=>n.classList.add('hidden'), 3000);
}

// ===== Fetch Records =====
async function fetchRecords(){
    const snap = await db.collection("GoodUX").doc("WhyMedia").collection("Users").get();
    records = snap.docs.map(d=>({id:d.id,...d.data()}));
    // console.log(records)
    renderRecordsList();
}

// ===== Render Records =====
function renderRecordsList(){
    const list = qs('#records-list');
    if(!records.length){
        list.innerHTML='<div class="no-records">No records found</div>';
        return;
    }
    list.innerHTML='';
    records.forEach(r=>{
        const div = document.createElement('div');
        div.className='record-item';
        div.dataset.id=r.id;
        div.innerHTML=`
        <div class='record-avatar-container'>
            <div class='record-avatar'>
                <img src='../Assets/Profile/${r.Id}.png' onerror='this.src="../Assets/Profile/profile.png"'>
            </div>
            <div>
                <div class='record-name'>${r.Name||''}</div>
                <div class='record-phone'>${r["Primary Mobile Number"]||''}</div>
            </div>
        </div>
        <div class='record-details'>
            <div class='record-actions'>
                <button class='record-action-icon edit-icon' data-id='${r.id}'><div class='edit-icon-container'><a style="display:flex;" title='View' href='../?@=${r.Id}' target='_blank'><img src="../Assets/eye_icon.svg" /></a></div></button>
                <button class='record-action-icon edit-icon' data-id='${r.id}'><div class='edit-icon-container'><img title='Edit' src="../Assets/edit_icon.svg" /></div></button>
                <button class='record-action-icon delete-icon' data-id='${r.id}'><div class='delete-icon-container'><img title='Delete' src="../Assets/delete_icon.svg" /></div></button>
            </div>
        </div>`;
        list.appendChild(div);
    });
}

// ===== Set Image with fallback =====
function setImage(selector, userSrc, fallback){
    const img = document.querySelector(selector);
    if(!img) return;
    img.removeAttribute("src");
    img.src="";
    let triedFallback = false;
    img.onerror = () => {
        if(!triedFallback){
            triedFallback = true;
            img.src = fallback + `?v=${Date.now()}`;
        } else {
            img.style.display="none";
        }
    };
    img.src = userSrc + `?v=${Date.now()}`;
}

// ===== Cropped Images Data =====
let croppedProfileData = null;
// let croppedBannerData = null;

// ===== Convert DataURL to Blob =====
function dataURLtoBlob(dataURL){
    const arr = dataURL.split(',');
    const mime = arr[0].match(/:(.*?);/)[1];
    const bstr = atob(arr[1]);
    let n = bstr.length;
    const u8arr = new Uint8Array(n);
    while(n--){
        u8arr[n] = bstr.charCodeAt(n);
    }
    return new Blob([u8arr], {type:mime});
}

// ===== Upload Image to PHP =====
async function uploadImageToPHP(dataURL, filename){
    const blob = dataURLtoBlob(dataURL);
    const formData = new FormData();
    formData.append('image', blob, filename); 
    const response = await fetch('../upload.php', {method:'POST', body: formData});
    const result = await response.text();
    console.log('Upload result:', result);
    return result;
}

// ===== Populate Form =====
function populateForm(r){
    selectedRecordId = r.id;
    const map = { 
        Id:'#id',
        Name:'#name', Role:'#role', Email:'#email', 
        'Primary Mobile Number':'#primary_phone',
        Facebook:'#facebook', Instagram:'#instagram', 
        Linkedin:'#linkedin', Youtube:'#youtube', Whatsapp:'#whatsapp'
        // , Arattai:'#arattai' 
    };
    Object.keys(map).forEach(k=>{
        const el = qs(map[k]);
        if(el) el.value = r[k]||'';
    });

    const idInput = qs('#id');
    if(idInput){
        idInput.readOnly = true;
    }

    const phone = (r["Primary Mobile Number"]||'').replace(/[^\d+]/g,'');
    setImage('.profile-img-container img', `../Assets/Profile/${r.Id}.png`, '../Assets/Profile/profile.png');
}


let formMode = selectedRecordId ? 'EDIT' : 'ADD';

// ===== Save Record =====
async function saveRecord(data) {
    const usersRef = db.collection("GoodUX").doc("WhyMedia").collection("Users");
    let action = "";

    try {
        if (selectedRecordId) {
            await usersRef.doc(selectedRecordId).update(data);
            action = "updated";
            showNotification(`Record updated successfully`, true);
        } else {
            // Creation path: check duplicate by field "Id" before creating
            const duplicateCheck = await usersRef.where("Id", "==", String(data.Id)).limit(1).get();
            if (!duplicateCheck.empty) {
                // Duplicate found -> do not create
                showNotification(`Duplicate ID "${data.Id}" found! Record not created.`, false);
                return "duplicate";
            }
            await usersRef.add(data);
            action = "created";
            showNotification(`Record created successfully`, true);
        }

        await fetchRecords();
        resetForm();

        return action;
    } catch (err) {
        console.error("saveRecord error:", err);
        showNotification("Error saving record: " + (err.message || err), false);
        return "error";
    }
}
// ===== Delete Record =====
async function deleteRecord(id){
    if(confirm('Delete this record?')){
        await db.collection("GoodUX").doc("WhyMedia").collection("Users").doc(id).delete();
        showNotification('Deleted');
        fetchRecords();
        if(selectedRecordId===id) resetForm();
    }
}

// ===== Form Handling =====
qs('#crud-form').addEventListener('submit', async function(e) {
    
    e.preventDefault();
    qs('#save-btn').disabled= true;

    // Collect form data
    console.log(typeof(qs('#id').value),qs('#id').value);
    var data = {
        Id: qs('#id').value,
        Name: qs('#name').value,
        Role: qs('#role').value,
        Email: qs('#email').value,
        'Primary Mobile Number': qs('#primary_phone').value.trim(),
        Facebook: qs('#facebook').value,
        Instagram: qs('#instagram').value,
        Linkedin: qs('#linkedin').value,
        Youtube: qs('#youtube').value,
        Whatsapp: qs('#whatsapp').value,
        // Arattai: qs('#arattai').value
    };

    // Generate vCard content
    var vcfContent = "BEGIN:VCARD\n";
    vcfContent += "VERSION:3.0\n";
    vcfContent += "FN:" + data.Name + "\n";
    vcfContent += "N:" + data.Name + ";;;\n";

    if (data['Company Name']) vcfContent += "ORG:" + data['Company Name'] + "\n";
    if (data.Role) vcfContent += "TITLE:" + data.Role + "\n";

    if (data['Primary Mobile Number']) vcfContent += "TEL;TYPE=CELL:" + data['Primary Mobile Number'] + "\n";
    if (data['Secondary Mobile Number']) vcfContent += "TEL;TYPE=CELL:" + data['Secondary Mobile Number'] + "\n";

    if (data.Email) vcfContent += "EMAIL;TYPE=INTERNET:" + data.Email + "\n";
    if (data['Company Email']) vcfContent += "EMAIL;TYPE=WORK:" + data['Company Email'] + "\n";

    if (data['Company Address']) vcfContent += "ADR;TYPE=WORK:;;" + data['Company Address'] + ";;;;\n";
    if (data.Website) vcfContent += "URL:" + data.Website + "\n";

    if (data.Facebook) vcfContent += "X-SOCIALPROFILE;TYPE=facebook:" + data.Facebook + "\n";
    if (data.Linkedin) vcfContent += "X-SOCIALPROFILE;TYPE=linkedin:" + data.Linkedin + "\n";
    if (data.Instagram) vcfContent += "X-SOCIALPROFILE;TYPE=instagram:" + data.Instagram + "\n";
    if (data.Whatsapp) vcfContent += "X-SOCIALPROFILE;TYPE=whatsapp:" + data.Whatsapp + "\n";
    if (data.Youtube) vcfContent += "X-SOCIALPROFILE;TYPE=youtube:" + data.Youtube + "\n";

    vcfContent += "END:VCARD\n";

    try {
        // Upload images first (if cropped)
        if(croppedProfileData){
            console.log('Uploading profile image for', data.Id);
            await uploadImageToPHP(croppedProfileData, data.Id + ".png");
            croppedProfileData = null;
        }
        // Save record to Firestore
        const result = await saveRecord(data);
        if (result === "created" || result === "updated") {
            // Send vCard to PHP 5.6 backend
            var xhr = new XMLHttpRequest();
            xhr.open('POST', '../save_vcard.php', true);
            xhr.setRequestHeader('Content-Type', 'application/json;charset=UTF-8');
            xhr.onreadystatechange = function() {
                if(xhr.readyState === 4) {
                    if(xhr.status === 200) {
                        try {
                            var resp = JSON.parse(xhr.responseText);
                            if(resp.success) showNotification("vCard Saved Successfully", true);
                            else showNotification("Failed to save vCard: " + resp.error, false);
                        } catch(e) {
                            showNotification("Invalid server response", false);
                            console.error("JSON parse error:", e, xhr.responseText);
                        }
                    } else {
                        showNotification("Error saving vCard. Status: " + xhr.status, false);
                    }
                }
            };
            xhr.send(JSON.stringify({ filename: data.Id + ".vcf", vcard: vcfContent }));
        }
    } catch(error) {
        showNotification("Error saving record: " + error.message, false);
        console.error(error);
    }
    qs('#save-btn').disabled= false;
});

//  ===== Reset Form =====
function resetForm() {
    qs('#crud-form').reset();
    qs('.form-section.edit').scrollTo({ top: 0, behavior: 'smooth' });
    // Reset state
    selectedRecordId = null; 
    window.formMode = 'ADD'; 

    // Reset default images
    qs('.profile-img-container img').src = '../Assets/Profile/profile.png?v=' + Date.now();
    qs('.banner-img img').src = '../Assets/Banner.svg?v=' + Date.now();

    // Make phone number editable
    const idInput = qs('#id');
    if (idInput) {
        idInput.readOnly = false;
        idInput.classList.remove('readonly');
    }

    if (currentCropper) {
        currentCropper.destroy();
        currentCropper = null;
    }

    window.profileBlob = null;
    window.bannerBlob = null;

    if (qs('#save-btn')) qs('#save-btn').style.display = 'block';
    if (qs('#update-btn')) qs('#update-btn').style.display = 'none';
}

qs('#add-btn').addEventListener('click', () => {
    resetForm(); 
});

qs('#cancel-btn').addEventListener('click', () => {
    resetForm(); 
});



// ===== List Item Events =====
qs('#records-list').addEventListener('click', e=>{
    const id = e.target.closest('button')?.dataset.id || e.target.closest('.record-item')?.dataset.id;
    if(!id) return;
    if(e.target.closest('.delete-icon')) deleteRecord(id);
    else {
        const rec = records.find(r=>r.id===id);
        if(rec) populateForm(rec);
    }
    qs('.form-section.edit').scrollTo({ top: 0, behavior: 'smooth' });
});

// ===== Cropper Modal =====
let cropperModal = qs('#cropper-modal'), currentCropper=null, currentImageType=null, currentImageElement=null;
function openCropperModal(src,type,element){
    currentImageType = type;
    currentImageElement = element;
    qs('#cropper-modal-image').src = src;
    cropperModal.style.display = 'block';
    if(currentCropper) currentCropper.destroy();
    qs('#cropper-modal-image').onload = ()=>{
        currentCropper = new Cropper(qs('#cropper-modal-image'), {
            aspectRatio: type==='banner'?25/11:1,
            viewMode: 1
        });
    };
}

function applyCrop(){
    if(currentCropper && currentImageElement){
        const canvas = currentCropper.getCroppedCanvas();
        const dataURL = canvas.toDataURL();
        currentImageElement.src = dataURL;
        if(currentImageType==='profile') croppedProfileData = dataURL;
        closeCropper();
    }
}

function closeCropper(){
    cropperModal.style.display = 'none';
    if(currentCropper) currentCropper.destroy();
    currentCropper = null;
}

qs('#cropper-apply-btn').addEventListener('click', applyCrop);
qs('#cropper-cancel-btn').addEventListener('click', closeCropper);
qs('.cropper-close').addEventListener('click', closeCropper);

qs('#profile_img').addEventListener('change', e=>{
    const f = e.target.files[0];
    if(f){
        const r = new FileReader();
        r.onload = ()=>openCropperModal(r.result,'profile',qs('.profile-img-container img'));
        r.readAsDataURL(f);
    }
});        

qs('#profile-img-edit').addEventListener('click', (e) => {
    e.stopPropagation();
    const input = qs('#profile_img');
    input.value = '';
    input.click();
});

// ===== Init =====
document.addEventListener('DOMContentLoaded', ()=>{ fetchRecords(); });