<?php
// save_vcard.php

// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Get raw POST data
$data = file_get_contents('php://input');
if (!$data) {
    echo json_encode(array('success'=>false, 'error'=>'No data received'));
    exit;
}

// Decode JSON
$json = json_decode($data, true);
if (!$json) {
    echo json_encode(array('success'=>false, 'error'=>'Invalid JSON'));
    exit;
}

// Extract filename and vCard content
$filename = isset($json['filename']) ? basename($json['filename']) : '';
$vcard = isset($json['vcard']) ? $json['vcard'] : '';

if (empty($filename) || empty($vcard)) {
    echo json_encode(array('success'=>false, 'error'=>'Filename or vCard content missing'));
    exit;
}

// Path to save vCards
$uploadDir = dirname(__FILE__) . '/Assets/Profile/';
if (!is_dir($uploadDir)) {
    if (!mkdir($uploadDir, 0777, true)) {
        echo json_encode(array('success'=>false, 'error'=>'Failed to create directory'));
        exit;
    }
}

// Save vCard file
$filepath = $uploadDir . $filename;
$result = @file_put_contents($filepath, $vcard);

if ($result !== false) {
    echo json_encode(array('success'=>true, 'path'=>'Assets/Profile/'.$filename));
} else {
    echo json_encode(array('success'=>false, 'error'=>'Failed to save vCard'));
}
?>
